<?php
/**
 * The template for displaying the header
 *
 * Displays all of the head element and everything up until the "site-content" div.
 *
 * @package WordPress
 * @subpackage Twenty_Fifteen
 * @since Twenty Fifteen 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<!--[if lt IE 9]>
	<script src="<?php echo esc_url( get_template_directory_uri() ); ?>/js/html5.js"></script>
	<![endif]-->
	<?php wp_head(); ?>
	<meta name="google-site-verification" content="ER-hGwTYXCdqQJk3TEk5ojjeyI8T0-CCXdXu-b2wX28" />
	<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=UA-127153331-1"></script>
	
<!-- <script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'UA-127153331-1');
</script> -->
	
	<script type="application/ld+json"> 
                {
                  "@context": "http://schema.org",
                  "@type": "EducationEvent",
                  "name": "UiPath Training",
                  "description": "RPA UIPATH GURU Providing result oriented uipath training in hyderabad duration is 5 weeks,Regular fast-track and weekend batches for workig professionals",
                  "image": "http://rpauipathguru.com/wp-content/uploads/2018/09/rpa-uipath-guru-header-825x250.jpg",
                  "performer":"RPA Uipath Guru",
                  "eventStatus": "open",
                  "location": {
                      "@type": "Place",
                      "name": "Classroom",
                      "address": {
                          "@type": "PostalAddress", "name": "UiPath Training", "addressLocality": "Hyderabad", "addressRegion": 

"india"
                      }
                      ,
                      "url": "http://rpauipathguru.com"
                  },
                  "aggregateRating": {
                      "@type": "AggregateRating", "ratingCount": "400", "ratingValue": "5", "reviewCount": "400"
                  }
                  ,
                  "offers": {
                      "@type": "AggregateOffer", "lowPrice": "000", "inventoryLevel" :"no limit", "url": "http://rpauipathguru.com", 

"availability": "In-stock", "price": "000", "priceCurrency": "INR", "validFrom": "2018-11-12"
                  }
                  ,
                  "startDate": "2018-12-17",
                  "endDate" : "2019-01-10",
                  "url" : "http://rpauipathguru.com"
                }

              </script>

</head>

<body <?php body_class(); ?>>
<div id="page" class="hfeed site">
	<a class="skip-link screen-reader-text" href="#content"><?php _e( 'Skip to content', 'twentyfifteen' ); ?></a>

	<div id="sidebar" class="sidebar">
		<header id="masthead" class="site-header" role="banner">
			<div class="site-branding">
				<?php
					twentyfifteen_the_custom_logo();

					if ( is_front_page() && is_home() ) : ?>
						<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
					<?php else : ?>
						<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
					<?php endif;

					$description = get_bloginfo( 'description', 'display' );
					if ( $description || is_customize_preview() ) : ?>
						<p class="site-description"><?php echo $description; ?></p>
					<?php endif;
				?>
				<button class="secondary-toggle"><?php _e( 'Menu and widgets', 'twentyfifteen' ); ?></button>
			</div><!-- .site-branding -->
		</header><!-- .site-header -->

		<?php get_sidebar(); ?>
	</div><!-- .sidebar -->

	<div id="content" class="site-content">
