<?php
/**
 * Widget Social Links
 *
 * @package Preschool and Kindergarten
 */
 
function preschool_and_kindergarten_register_social_links_widget() {

    register_widget( 'preschool_and_kindergarten_Social_links' );
}

add_action( 'widgets_init', 'preschool_and_kindergarten_register_social_links_widget' );
 
 /**
 * Adds preschool_and_kindergarten_Social_Links widget.
 */
class preschool_and_kindergarten_Social_links extends WP_Widget {

	/**
	 * Register widget with WordPress.
	 */
	function __construct() {
		parent::__construct(
			'preschool_and_kindergarten_social_links', // Base ID
			__( 'RARA: Social Links', 'preschool-and-kindergarten' ), // Name
			array( 'description' => __( 'A Social Links Widget', 'preschool-and-kindergarten' ), ) // Args
		);
	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args     Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
	   
        $title   = ! empty( $instance['title'] ) ? $instance['title'] : __( 'Social Media', 'preschool-and-kindergarten' );		
        
        echo $args['before_widget'];

        if( $title ) echo $args['before_title'] . apply_filters( 'widget_title', $title, $instance, $this->id_base ) . $args['after_title'];
        
        preschool_and_kindergarten_social_cb();

        echo $args['after_widget'];
        
	}

	/**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance ) {
        
        $title   = ! empty( $instance['title'] ) ? $instance['title'] : __( 'Social Media', 'preschool-and-kindergarten' );		
        
        ?>
		
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php _e( 'Title', 'preschool-and-kindergarten' ); ?></label> 
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
		</p>
        
        <p>
            <small><?php esc_html_e( 'You can change the social links from the customizer in Social Settings options.', 'preschool-and-kindergarten' ); ?></small>
        </p>
        
		<?php 
	}

	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		
        $instance['title']       = ! empty( $new_instance['title'] ) ? sanitize_text_field( $new_instance['title'] ) : __( 'Social Media', 'preschool-and-kindergarten' );
        
        return $instance;
	}

} // class preschool_and_kindergarten_Social_Links 